unit ListToList1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ListBoxLeft: TListBox;
    ListBoxRight: TListBox;
    ButtonAllToR: TButton;
    ButtonSelectToR: TButton;
    ButtonSelectToL: TButton;
    ButtonAllToL: TButton;
    ComboBoxLoadRun: TComboBox;
    StatusBarReport1: TStatusBar;
    ComboBoxCM: TComboBox;
    Edit1: TEdit;
    SpeedButtonUpDate: TSpeedButton;
    CheckBoxSortLeft: TCheckBox;
    CheckBoxSortRight: TCheckBox;
    SpeedButtonLoad: TSpeedButton;
    SpeedButtonSave: TSpeedButton;
    SpeedButtonNewStr: TSpeedButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure ButtonSelectToRClick(Sender: TObject);
    procedure ButtonSelectToLClick(Sender: TObject);
    procedure ButtonAllToRClick(Sender: TObject);
    procedure ButtonAllToLClick(Sender: TObject);
    procedure ListBoxRightClick(Sender: TObject);
    procedure SpeedButtonUpDateClick(Sender: TObject);
    procedure CheckBoxSortLeftClick(Sender: TObject);
    procedure CheckBoxSortRightClick(Sender: TObject);
    procedure SpeedButtonLoadClick(Sender: TObject);
    procedure SpeedButtonSaveClick(Sender: TObject);
    procedure SpeedButtonNewStrClick(Sender: TObject);
  private
    { Private declarations }
    procedure ListBoxLoad (RqListBox : TListBox; RqFileName : string);
    procedure CopySelectInterListBox (RqOp : char; RqListBoxFrom, RqListBoxTo: TListBox);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
procedure TForm1.ListBoxLoad (RqListBox : TListBox; RqFileName : string);
var WStr1 : string;
begin
   WStr1 := FileSearch(RqFileName, GetCurrentDir);
   if WStr1 = ''
   then begin
        ShowMessage('     = ' + RqFileName);
   end
   else begin
       //      
       RqListBox.Items.LoadFromFile(GetCurrentDir() + '\' + RqFileName);
       StatusBarReport1.Panels[0].Text := 'Load';
       StatusBarReport1.Panels[1].Text := '   ' +
                                           GetCurrentDir() + '\' +
                                           RqFileName;
   end;
end; {of ListBoxLoad}


procedure TForm1.CopySelectInterListBox (RqOp : char; RqListBoxFrom, RqListBoxTo: TListBox);
begin
 if (RqListBoxFrom is TListBox) and (RqListBoxTo is TListBox)
 then begin
    case RqOp of
    'C' : begin {Copy}
            RqListBoxFrom.CopySelection(RqListBoxTo);
            StatusBarReport1.Panels[0].Text := 'Copy';
            StatusBarReport1.Panels[1].Text := ' ' +
                                            IntToStr(RqListBoxFrom.SelCount) +
                                            ' ';
            // RqListBoxFrom.ClearSelection;
          end;
    'M' : begin {Move}
            RqListBoxFrom.CopySelection(RqListBoxTo);
            StatusBarReport1.Panels[0].Text := 'Move';
            StatusBarReport1.Panels[1].Text := ' ' +
                                            IntToStr(RqListBoxFrom.SelCount) +
                                            ' ';
            RqListBoxFrom.DeleteSelected;
          end;
    'D' : begin {Delete}
            StatusBarReport1.Panels[0].Text := 'Delete';
            StatusBarReport1.Panels[1].Text := ' ' +
                                            IntToStr(RqListBoxFrom.SelCount) +
                                            ' ';
            RqListBoxFrom.DeleteSelected;
          end;
    end; {of case RqOp}
  end;
end;


// ==========================================
//      ListBox
procedure TForm1.SpeedButtonLoadClick(Sender: TObject);
begin
 ListBoxLoad(ListBoxLeft,ComboBoxLoadRun.Text);
end;

procedure TForm1.SpeedButtonSaveClick(Sender: TObject);
var WStr1 : string;
begin
  if ListBoxLeft.Count > 0
  then begin
     WStr1 :=GetCurrentDir() + '\' + ComboBoxLoadRun.Text;
     try
       ListBoxLeft.Items.SaveToFile(WStr1);
       StatusBarReport1.Panels[0].Text := 'Save';
       StatusBarReport1.Panels[1].Text := '  -> ' +
                                           WStr1;
     except
       StatusBarReport1.Panels[0].Text := 'ERROR';
       StatusBarReport1.Panels[1].Text := '    -> ' +
                                           WStr1;
       Beep;                                    
     end;
  end;
end;

// ==========================================
//     ListBoxes
// ==========================================
//    ListBoxLeft  ListBoxRight
procedure TForm1.ButtonSelectToRClick(Sender: TObject);
begin
  case  ComboBoxCM.ItemIndex of
  0 : CopySelectInterListBox('C', ListBoxLeft,ListBoxRight);
  1 : CopySelectInterListBox('M', ListBoxLeft,ListBoxRight);
  2 : CopySelectInterListBox('M', ListBoxLeft,ListBoxRight);
  end;
end;
procedure TForm1.ButtonAllToRClick(Sender: TObject);
begin
  ListBoxLeft.SelectAll;
  case  ComboBoxCM.ItemIndex of
  0 : CopySelectInterListBox('C', ListBoxLeft,ListBoxRight);
  1 : CopySelectInterListBox('M', ListBoxLeft,ListBoxRight);
  2 : CopySelectInterListBox('M', ListBoxLeft,ListBoxRight);
  end;
end;

// ==========================================
//    ListBoxRight  ListBoxLeft
procedure TForm1.ButtonSelectToLClick(Sender: TObject);
begin
  case  ComboBoxCM.ItemIndex of
  0 :  CopySelectInterListBox('C', ListBoxRight, ListBoxLeft);
  1 :  CopySelectInterListBox('M', ListBoxRight, ListBoxLeft);
  2 :  CopySelectInterListBox('D', ListBoxRight, ListBoxLeft);
  end;
end;

procedure TForm1.ButtonAllToLClick(Sender: TObject);
begin
  ListBoxRight.SelectAll;
  case  ComboBoxCM.ItemIndex of
  0 :  CopySelectInterListBox('C', ListBoxRight, ListBoxLeft);
  1 :  CopySelectInterListBox('M', ListBoxRight, ListBoxLeft);
  2 :  CopySelectInterListBox('D', ListBoxRight, ListBoxLeft);
  end;
end;

// ==========================================
//  ListBoxRight
// ==========================================
//    Edit
procedure TForm1.ListBoxRightClick(Sender: TObject);
begin
  Edit1.Text:=ListBoxRight.Items.Strings[ListBoxRight.ItemIndex];
end;

//      Edit
procedure TForm1.SpeedButtonUpDateClick(Sender: TObject);
var Ind1  : integer;
    Found : boolean;
    WStr1 : string;
begin
 Found := False;
 if ListBoxRight.SelCount > 0
 then begin
    for Ind1:=0 to ListBoxRight.Count -1 do
    begin
      //     
      if ListBoxRight.Selected[Ind1]
      then begin
          Found := True;
          break;
      end;
    end;
    if Found
    then begin
       WStr1:= ListBoxRight.Items.Strings[Ind1];
       ListBoxRight.Items.Strings[Ind1]:= Edit1.Text;
       StatusBarReport1.Panels[0].Text := 'UpDate';
       StatusBarReport1.Panels[1].Text := '   -> ' +
                                           WStr1;
    end;
  end;
end;

//   
procedure TForm1.SpeedButtonNewStrClick(Sender: TObject);
begin
   if Edit1.Text <> ''
   then begin
        ListBoxRight.Items.Add(Edit1.Text);
        StatusBarReport1.Panels[0].Text := 'Add';
        StatusBarReport1.Panels[1].Text := '  -> ' +
                                            Edit1.Text;
   end;
end;
// ==========================================
//   ListBox
procedure TForm1.CheckBoxSortLeftClick(Sender: TObject);
begin
 ListBoxLeft.Sorted := CheckBoxSortLeft.Checked;
end;

procedure TForm1.CheckBoxSortRightClick(Sender: TObject);
begin
 ListBoxRight.Sorted := CheckBoxSortRight.Checked;
end;





end.
